/***********************************************************************************/
/**										  **/
/**		Panorama Applet							  **/
/**				file name : Panorama_11.java			  **/
/**				window size : WIDTH x HEIGHT			  **/
/**				working: ϕ\گ			  **/
/**				param : "image"  (ω摜w)		  **/
/**				param : "stime"  (ذߎԎw)		  **/
/**				param : "step"   (۰ٽïߒlw[2,4,32]) **/
/**				param : "mode"   (Ӱގw[0:[Œ~]        )	  **/
/**				                 (        [1:[Ŏ]]    )	  **/
/**				                 (        [2:EAٰ])	  **/
/**				                 (        [3:㉺Aٰ])	  **/
/**				file : ω摜 (param"image"wɂ摜)	  **/
/**										  **/
/**				1997/08/23 ver1.0 created by H.Machida		  **/
/**				1997/10/30 ver1.1 updated by H.Machida		  **/
/**				  (JDK1.1ł̂΍A۰ِǓ)	  **/
/**										  **/
/***********************************************************************************/

import java.awt.*;


public class Panorama_11 extends java.applet.Applet implements Runnable {


/********** instance **********/

  Thread thread;				// گ
  int appwidth;					// گĉ
  int appheight;				// گďc
  int stime;					// ذߎ
  int step;					// ۰ٽïߒl(2,4,8,16,32)
  int nowstep;					// ݂̽۰ٽïߒl
  int mode;					// Ӱ(۰Ӱ)
  int status;					// ð(۰ٕƓ)
  int x;					// 摜`ʒuxW
  int y;					// 摜`ʒuyW
  Image image;					// 摜(ω摜)
  MediaTracker mt;				// ިׯ
  boolean mouseflag;				// ϳ׸
  int imgwidth;					// 摜
  int imgheight;				// 摜c

  Image offimg;					// ̽ذݲҰ
  Graphics offscr;				// ̽ذݕ`޼ު

  final String STATUSTEXT = "Panorama 1.1";	// ðײݕ\÷


/********** init **********/

  public void init() {

    stime = 120;				// eݽݽ(lݒ)
    step = 8;
    mode = 1;
    status = 0;
    x = 0;
    y = 0;
    mouseflag = false;

    appwidth = size().width;			// گĉ擾
    appheight = size().height;			// گďc擾


    String param = null;			// eҰ̓ǂݏo

    param = getParameter("image");		// "image"Ǐoĉ摜ݒ
    if (param == null) {
      image = null;
    } else {
      image = getImage(getDocumentBase(), param); // (摜۰ިݸނJn)
      mt = new MediaTracker(this);		// (ިׯݒ)
      mt.addImage(image ,0);
    }

    param = getParameter("stime");		// "stime"ǏoĽذߎԂݒ
    if (param != null) {
      stime = Integer.valueOf(param).intValue();
    }

    param = getParameter("step");		// "step"ǏoĽ۰ٽïߒlݒ
    if (param != null) {
      step = Integer.valueOf(param).intValue();
    }

    param = getParameter("mode");		// "mode"ǏoēӰނݒ
    if (param != null) {
      mode = Integer.valueOf(param).intValue();
    }


    nowstep = step;				// ݂̽۰ٽïߒl

    offimg = createImage(appwidth,appheight);	// ̽ذݲҰނ쐬
    offscr = offimg.getGraphics();		// ̽ذݕ`޼ުĂ

    offscr.setFont(new Font("Courier", Font.PLAIN, 12)); // ̽ذݕ`̫Ăݒ
    setBackground(Color.lightGray);		// گĂ̔wiFݒ

  }


/********** start **********/

  public void start() {

    thread = new Thread(this);
    thread.start();

  }


/********** stop **********/

  public void stop() {

    thread.stop();
    thread = null;

  }


/********** run **********/

  public void run() {

    if (image != null) {			// ިׯ܂őҋ@
      try { mt.waitForID(0); }
      catch (InterruptedException e) {};
    }

    while( true ) {				// ٰ
      try { Thread.currentThread().sleep(stime);}
      catch (InterruptedException e) {};
      repaint();
    }

  }


/********** paint **********/

  public void paint(Graphics scr) {

    if (status == 0) {				// ............ 摜۰ިݸޒ̏ꍇ

      if (mt.checkID(0) == true) {		// 摜۰ިݸނ?
        imgwidth = image.getWidth(this);	// (摜ނ擾)
        imgheight = image.getHeight(this);
        if (mode == 3) {			// (ðXV)
          status = 6;
        } else {
          status = 1;
        }
      }

      offscr.setColor(Color.lightGray);		// ̽ذݲҰނ۰ިݸүނ`
      offscr.fillRect(0,0, appwidth,appheight);
      offscr.setColor(Color.black);
      offscr.drawString("Loading image", 10,20);

    } else {					// ............ 摜۰ިݸފ̏ꍇ

      offscr.drawImage(image, x,y, this);	// ̽ذݲҰނɉ摜`

      if (x < -(imgwidth - appwidth)) {		// ̽ذݲҰމEɉ摜A`
        offscr.drawImage(image, imgwidth+x,y, this); // (EA)
      }

      if (y < -(imgheight - appheight)) {	// ̽ذݲҰމɉ摜A`
        offscr.drawImage(image, x,imgheight+y, this); // (㉺A)
      }

    }

    scr.drawImage(offimg, 0,0, this);		// ̽ذݲҰނگĂɕ`

    if (mouseflag == true) {			// ϳگēȂ΁A
      showStatus(STATUSTEXT + lookto());	//         ðײ݂үނ\
    }

  }


/********** update **********/

  public void update(Graphics scr) {

    switch (status) {				// ------------- ðɂes

      case 0:					// 摜۰ިݸޒ --------- status 0
        paint(scr);				// paint()㏑Ŏs
        break;

      case 1:					// 摜Eֽ۰ ----------- status 1
        x = x - nowstep;			// (xXV)
        switch (mode) {
          case 0:				// (Ӱ0̎)
          case 3:				// (Ӱ3̎)
            if (x <= (-imgwidth + appwidth)) {
              x = -imgwidth + appwidth;
              status = 4;
            }
            break;
          case 1:				// (Ӱ1̎)
            if (x <= (-imgwidth + appwidth)) {
              x = -imgwidth + appwidth;
              status = 2;
            }
            break;
          case 2:				// (Ӱ2̎)
            if (x <= -imgwidth) {
              x = 0;
            }
            break;
        }
        paint(scr);				// paint()㏑Ŏs
        break;

      case 2:					// 摜ֽ۰ ---------- status 2
        x = x + nowstep;			// (xXV)
        switch (mode) {
          case 0:				// (Ӱ0̎)
          case 3:				// (Ӱ3̎)
            if (x >= 0) {
              x = 0;
              status = 5;
            }
            break;
          case 1:				// (Ӱ1̎)
            if (x >= 0) {
              x = 0;
              status = 1;
            }
            break;
          case 2:				// (Ӱ2̎)
            if (x >= 0) {
              x = -imgwidth;
            }
            break;
        }
        paint(scr);				// paint()㏑Ŏs
        break;

      case 6:					// 摜ֽ۰ ---------- status 6
        y = y - nowstep;			// (yXV)
        switch (mode) {
          case 0:				// (Ӱ0̎)
          case 2:				// (Ӱ2̎)
            if (y <= (-imgheight + appheight)) {
              y = -imgheight + appheight;
              status = 8;
            }
            break;
          case 1:				// (Ӱ1̎)
            if (y <= (-imgheight + appheight)) {
              y = -imgheight + appheight;
              status = 7;
            }
            break;
          case 3:				// (Ӱ3̎)
            if (y <= -imgheight) {
              y = 0;
            }
            break;
        }
        paint(scr);				// paint()㏑Ŏs
        break;

      case 7:					// 摜ֽ۰ ---------- status 7
        y = y + nowstep;			// (yXV)
        switch (mode) {
          case 0:				// (Ӱ0̎)
          case 2:				// (Ӱ2̎)
            if (y >= 0) {
              y = 0;
              status = 9;
            }
            break;
          case 1:				// (Ӱ1̎)
            if (y >= 0) {
              y = 0;
              status = 6;
            }
            break;
          case 3:				// (Ӱ3̎)
            if (y >= 0) {
              y = -imgheight;
            }
            break;
        }
        paint(scr);				// paint()㏑Ŏs
        break;

    }

  }


/********** mouseEnter **********/

  public boolean mouseEnter(Event e, int x, int y) {

    mouseflag = true;

    showStatus(STATUSTEXT + lookto());		// ðײ݂үނ\

    return true;

  }


/********** mouseUp **********/

  public boolean mouseUp(Event e, int x, int y) {

    double xp = x;
    double yp = y;
    double w = appwidth;
    double h = appheight;
    int newstatus;

						// گĂΊpŕ㉺E
    if ((xp / yp) < (w / h)) {
						// (EΊp̏ꍇŁA)
      if ((xp / (h - yp)) < (w / h)) {
        newstatus = 2;				// (EオΊp = Left)
      } else {
        newstatus = 6;				// (EオΊpE = Down)
      }

    } else {
						// (EΊpȄꍇŁA)
      if ((xp / (h - yp)) < (w / h)) {
        newstatus = 7;				// (EオΊp = Up)
      } else {
        newstatus = 1;				// (EオΊpE = Right)
      }
    }

						// گĂ9Ƃ
    if (xp >= (w / 3) && xp <= ((w / 3) * 2)) {
      if (yp >= (h / 3) && yp <= ((h / 3) * 2)) {
        newstatus = 3;				// (9̒ = Pause)
      }
    }


    if (newstatus == status) {			// ̍ĸدȂ΁A
      nowstep += nowstep;			//   ݂̽۰ٽïߒl  2{(max=32)
      if (nowstep >= 32) nowstep = 32;
    }

    if (newstatus == 3) {			// ̸دȂ΁A
      nowstep = 2;				//   ݂̽۰ٽïߒl  2(=min)
    }

    status = newstatus;				// statusXV

    showStatus(STATUSTEXT + lookto());		// ðײ݂үނ\

    return true;

  }


/********** mouseExit **********/

  public boolean mouseExit(Event e, int x, int y) {

    mouseflag = false;

    showStatus("");				// ðײ݂үނ

    return true;

  }


/********** methods **********/

  String lookto() {				// ۰ٕ\÷č쐬

    if (status == 0) return " ... Loading image...";
    if (status == 1) return " ... See Right!";
    if (status == 2) return " ... See Left!";
    if (status == 3) return " ... Pause!";
    if (status == 4) return " ... Right End!";
    if (status == 5) return " ... Left End!";
    if (status == 6) return " ... See Down!";
    if (status == 7) return " ... See Up!";
    if (status == 8) return " ... Down End!";
    if (status == 9) return " ... Up End!";

    return " ... Error!";

  }


}
