import java.applet.*;
import java.awt.*;
import java.util.*;

/* a utility class that collects parameters, converts hex color parameter values, and fonts */

class ParameterCollector 
{
	public ParameterCollector(String counterToken, Applet a) {
		pCount = 1;
		while( a.getParameter(counterToken + pCount++) != null )
			;
		pCount = pCount-2;
		apl = a;
	}
	
	public int getCount() {
		return pCount;
	}
	
	public String[] get(String token) {
		String[] temp = new String[pCount];
		for (int i=0; i < pCount; i++) 
			temp[i] = apl.getParameter(""+token + (i+1)); 
		return temp;
	}
	
	public Color[] hexConvert(String[] hexString)
	{
	   Color[] colorArray = new Color[pCount];
	   
	   for (int i=0; i < hexString.length; i++) {
		   int a = getDec(hexString[i].substring(0, 1));
		   int b = getDec(hexString[i].substring(1, 2));
		   int c = getDec(hexString[i].substring(2, 3));
		   int d = getDec(hexString[i].substring(3, 4));
		   int e = getDec(hexString[i].substring(4, 5));
		   int f = getDec(hexString[i].substring(5, 6));

		   int x = (a * 16) + b;
		   int y = (c * 16) + d;
		   int z = (e * 16) + f;

		   Color col = new Color(x,y,z);
		   if (col != null)
				colorArray[i] = col;
		   else
				colorArray[i] = Color.white;
		}
		return colorArray;
	}

	public Color hexConvert(String hexString)
	{
		 Color[] colorArray = new Color[1];
		 String[] temp = new String[1];
		 temp[0] = hexString;
		 
		 colorArray = hexConvert(temp);
		 
		 return colorArray[0];
	}
	
	private int getDec(String hex)
	{	
		int dValue;
		if(hex.equalsIgnoreCase("A"))		dValue = 10;
		else if(hex.equalsIgnoreCase("B"))	dValue = 11;
		else if(hex.equalsIgnoreCase("C"))	dValue = 12;
		else if(hex.equalsIgnoreCase("D"))	dValue = 13;
		else if(hex.equalsIgnoreCase("E"))	dValue = 14;
		else if(hex.equalsIgnoreCase("F"))	dValue = 15;
		else 
			try {
				dValue = Integer.parseInt(hex);
			}
			catch (NumberFormatException e) {
				dValue = 0;
			}

		return dValue;
	}
	
	public int getFontStyle(String s)
	{
		if (s.equalsIgnoreCase("bold")) return Font.BOLD;
		else if (s.equalsIgnoreCase("italic")) return Font.ITALIC;
		else if (s.equalsIgnoreCase("bolditalic") || s.equalsIgnoreCase("bold italic")) return (Font.BOLD | Font.ITALIC);
		else return Font.PLAIN;
	}
	
	private Applet apl;
	private int pCount;
}
