//TextFade.java by Alec Cove. 

import java.applet.*;
import java.awt.*;
import java.util.*;

public class TextFade extends Applet implements Runnable
{
	public void init() { 
		imageBuffer = createImage(size().width, size().height);
        bGraphics = imageBuffer.getGraphics();
       	currentLink = 0;
		errorMessage ="";
	
		try {
			linkDelay = Integer.parseInt(getParameter("linkdelay"));
			fadeSpeed = Integer.parseInt(getParameter("fadespeed"));
			fSize = Integer.parseInt(getParameter("fontsize"));
			xStart = Integer.parseInt(getParameter("xstart"));
			yStart = Integer.parseInt(getParameter("ystart"));
			blockWidth = Integer.parseInt(getParameter("textblockwidth"));
			leading = Integer.parseInt(getParameter("leading"));
			paramsCollected = true;
		} catch (NumberFormatException e) {
			paramsCollected = false;
		}
		
		pc = new ParameterCollector("string_", this);
		paramStrings = pc.get("string_");
		paramUrls = pc.get("url_");
		textColor = pc.hexConvert(getParameter("textcolor"));
		rollColor = pc.hexConvert(getParameter("rollcolor"));
		backColor = pc.hexConvert(getParameter("backcolor"));
		
		String fFace = getParameter("fontface");
		int fStyle = pc.getFontStyle(getParameter("fontstyle"));
		f = new Font(fFace, fStyle, fSize);
		
		if (paramsCollected) 
			buildTextLinks();
		else
			errorMessage = "WARNING: A parameter is set incorrectly!";
	}
	
	public void paint(Graphics g) {
		bGraphics.setColor(backColor);
		bGraphics.fillRect(0, 0, size().width, size().height);
	
		drawParagraph(textlinkArray[currentLink]);
		g.drawImage(imageBuffer, 0, 0, this);
	}
	
	private void drawParagraph(TextLink tl) {
		bGraphics.setColor(tl.getTextColor());
		bGraphics.setFont(f);
		for(int i=0; i < tl.getNumStrings(); i++)
			bGraphics.drawString( tl.getString(i), tl.getPos().x, tl.getLeading(i) );
	}
	
	private void buildTextLinks()
	{
		FontMetrics fm = bGraphics.getFontMetrics(f);
		textlinkArray = new TextLink[paramStrings.length];
		for (int i = 0; i < paramStrings.length; i++) {
			textlinkArray[i] = new TextLink (paramStrings[i], paramUrls[i], xStart, yStart, blockWidth, leading, textColor, rollColor, fm);
			textlinkArray[i].setTextColor(backColor); //start out fading in - same color as the background
		}
	}
	
	public void run() {
        while(true) {
            repaint();
			if ( !(textlinkArray[currentLink].getHighlight()) )
				cycleLinks(linkDelay);
            try {
                Thread.sleep(100);
            }
            catch (Exception e){
            }
        }
	}
	
	private void cycleLinks(int delaySeconds)
	{
		long t = new Date().getTime();
		
		if ( t - tSeconds > (delaySeconds * 1000) ) {
			if (textlinkArray[currentLink].fadeTo(backColor, fadeSpeed)) {
				currentLink = (currentLink >= textlinkArray.length-1) ? 0 : currentLink + 1;
				tSeconds = t;
			}
		} 
		else
			textlinkArray[currentLink].fadeTo(textColor, fadeSpeed);
	}
	
	public boolean mouseMove(Event evt, int x, int y) {
		showStatus(errorMessage);
		if ( textlinkArray[currentLink].mouseWithin(x, y) )
			textlinkArray[currentLink].setHighlight(true);
		else
			textlinkArray[currentLink].setHighlight(false);
		return true;
	}
	
	public boolean mouseExit(Event evt, int x, int y) {
		for (int i = 0; i < textlinkArray.length; i++)
			textlinkArray[i].setHighlight(false);
		return true;
	}
	
	public boolean mouseDown(Event evt, int x, int y) {
		if ( textlinkArray[currentLink].mouseWithin(x, y) ) {
			try {
				AppletContext context = getAppletContext();
				context.showDocument(textlinkArray[currentLink].getUrl());
			}
			catch(Exception e) {
				errorMessage = "Warning: one or more url parameters are set incorrectly!";
			}
		}
		return true;
	}

	public void start() {
		if (m_ScrollerApplet == null) {
			m_ScrollerApplet = new Thread(this);
			textlinkArray[currentLink].setHighlight(false);
			tSeconds = new Date().getTime();
			m_ScrollerApplet.start();
		}
	}
	
	public void stop() {
		if (m_ScrollerApplet != null) {
			m_ScrollerApplet.stop();
			m_ScrollerApplet = null;
		}
	}
	
	public void update(Graphics g) {
		paint(g);
    }

	private String[] paramStrings;
	private String[] paramUrls;
	private Color[] barColorsArray;
	private TextLink[] textlinkArray;
	private int currentLink;

	private long tSeconds;
	private ParameterCollector pc;
	private Image imageBuffer;
	private Graphics bGraphics;
	private Thread m_ScrollerApplet;

	private Color textColor;
	private Color rollColor;
	private Color backColor;
	private Font f;
	private int linkDelay;
	private int fadeSpeed;
	private int fSize;
	private int xStart; 
	private int yStart;
	private int blockWidth;
	private int leading;
	
	private boolean paramsCollected;
	private String errorMessage;
}
