/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class SecretPass
extends Applet
implements ActionListener,
Runnable {
    private boolean registered = false;
    private Thread loadingThread;
    private String errorString = null;
    private Image backgroundImage = null;
    private Image buttonImage = null;
    private Color[] colors = new Color[2];
    private String labelFontStyle = "TimesRoman";
    private int labelFontSize = 0;
    private FontMetrics labelFontMetrics;
    private int labelFontAlignment = 1;
    private int attemptsTotal = 3;
    private String targetFrame;
    private String extension;
    private int convertPassToCase = 0;
    private URL wrongPassURL = null;
    private String[] labelStrings = new String[5];
    private Dimension bufferSize = null;
    private Image bufferImage;
    private Graphics bufferGraphics;
    private int attemptsIndex = 0;
    private int labelStringsState = 0;
    private TextField passwordTextField;
    private Component submitButton;
    private Component registeredButton = null;

    public void init() {
        System.out.println("\nSecretPass Version 1.3.0");
        System.out.println("************************\n");
        String tempRegistered = this.getDocumentBase().getHost();
        if (tempRegistered == null) {
            tempRegistered = "";
        }
        this.registered = tempRegistered.equalsIgnoreCase("www.realapplets.com");
        System.out.println(" Unregistered applet, written by Geoffrey from RealApplets");
        System.out.println(" Get your applets from http://www.realapplets.com");
        System.out.println(" Removal of add without registration is punishable in a court of law.\n");
        String tempString = null;
        try {
            this.colors[0] = new Color(Integer.parseInt(this.getParameter("BackgroundColor"), 16));
            this.colors[1] = new Color(Integer.parseInt(this.getParameter("ForegroundColor"), 16));
        }
        catch (Exception exception) {
            this.setErrorString("The BackgroundColor or ForegroundColor parameter is wrong", exception);
            return;
        }
        this.setBackground(this.colors[0]);
        this.labelFontStyle = this.getParameter("LabelFontStyle");
        tempString = this.getParameter("labelFontSize");
        if (tempString.equals("") || tempString.equalsIgnoreCase("Auto")) {
            this.labelFontSize = 0;
        } else {
            try {
                this.labelFontSize = Integer.parseInt(tempString);
                if (this.labelFontSize <= 0) {
                    this.labelFontSize = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.labelStrings[0] = this.getParameter("LoadingLabel");
        this.labelStrings[1] = this.getParameter("EnterPassLabel");
        this.labelStrings[2] = this.getParameter("CorrectPassLabel");
        this.labelStrings[3] = this.getParameter("WrongPassLabel");
        this.labelStrings[4] = this.getParameter("NoMoreAttemptsLabel");
        this.targetFrame = this.getParameter("TargetFrame");
        this.extension = this.getParameter("Extension");
        tempString = this.getParameter("MaximumNumberOfAttempts");
        try {
            this.attemptsTotal = Integer.parseInt(tempString);
            if (this.attemptsTotal <= 0) {
                this.attemptsTotal = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        tempString = this.getParameter("WrongPassURL");
        if (!tempString.equals("") && !tempString.equalsIgnoreCase("None")) {
            try {
                this.wrongPassURL = tempString.length() > 7 && tempString.substring(0, 7).equalsIgnoreCase("HTTP://") ? new URL(tempString) : new URL(this.getDocumentBase(), tempString);
            }
            catch (MalformedURLException exception) {
                this.setErrorString("The WrongPassURL parameter is not a valid URL", exception);
                return;
            }
        }
        if ((tempString = this.getParameter("LabelFontAlignment")).equalsIgnoreCase("Left")) {
            this.labelFontAlignment = 0;
        } else if (tempString.equalsIgnoreCase("Center")) {
            this.labelFontAlignment = 1;
        } else if (tempString.equalsIgnoreCase("Right")) {
            this.labelFontAlignment = 2;
        }
        tempString = this.getParameter("ConvertPassToCase");
        if (tempString.equalsIgnoreCase("None")) {
            this.convertPassToCase = 0;
        } else if (tempString.equalsIgnoreCase("Lower")) {
            this.convertPassToCase = 1;
        } else if (tempString.equalsIgnoreCase("Upper")) {
            this.convertPassToCase = 2;
        }
        this.setLayout(null);
        Dimension size = this.getSize();
        if (size.width < 30 || size.height < 70) {
            this.setErrorString("The WIDTH and HEIGHT should be at least 30 and 70.");
            return;
        }
        this.passwordTextField = new TextField("");
        this.passwordTextField.setBounds(10, (size.height + 20) / 3, size.width - 20, (size.height - 40) / 3);
        this.passwordTextField.setBackground(Color.white);
        this.passwordTextField.setForeground(Color.black);
        this.passwordTextField.setEchoChar('*');
        this.passwordTextField.addActionListener(this);
        this.add(this.passwordTextField);
        tempString = this.getParameter("BackgroundPicture");
        if (!tempString.equals("") && !tempString.equalsIgnoreCase("None")) {
            this.backgroundImage = this.getImage(this.getCodeBase(), tempString);
        }
        String buttonTag = this.getParameter("ButtonTag");
        tempString = this.getParameter("ButtonPicture");
        if (!tempString.equals("") && !tempString.equalsIgnoreCase("None")) {
            this.buttonImage = this.getImage(this.getCodeBase(), tempString);
            String buttonTagFontStyle = this.getParameter("ButtonTagFontStyle");
            String buttonTagFontSize = this.getParameter("ButtonTagFontSize");
            Color[] buttonColors = new Color[]{this.colors[0], new Color(Integer.parseInt(this.getParameter("ButtonTagColorOut"), 16)), new Color(Integer.parseInt(this.getParameter("ButtonTagColorOver"), 16)), new Color(Integer.parseInt(this.getParameter("ButtonTagColorDown"), 16))};
            this.submitButton = new SPButton(this, this.buttonImage, buttonColors, buttonTagFontStyle, buttonTagFontSize, 0, buttonTag);
            if (!this.registered) {
                this.registeredButton = new SPButton(this, this.buttonImage, buttonColors, buttonTagFontStyle, buttonTagFontSize, -1, "RA");
            }
        } else {
            Button submitButton = new Button(buttonTag);
            submitButton.addActionListener(this);
            this.submitButton = submitButton;
            if (!this.registered) {
                Button registeredButton = new Button("RA");
                registeredButton.addActionListener(this);
                this.registeredButton = registeredButton;
            }
        }
        this.submitButton.setBounds(10, (size.height + 5) * 2 / 3, size.width - (this.registered ? 20 : size.height / 2), (size.height - 40) / 3);
        this.add(this.submitButton);
        if (!this.registered) {
            this.registeredButton.setBounds(10 + size.width - size.height / 2, (size.height + 5) * 2 / 3, size.height / 2 - 20, (size.height - 40) / 3);
            this.add(this.registeredButton);
        }
        if (this.backgroundImage != null || this.buttonImage != null) {
            this.loadingThread = new Thread(this);
            this.loadingThread.start();
        } else {
            this.labelStringsState = 1;
        }
        this.passwordTextField.requestFocus();
    }

    public void run() {
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.backgroundImage != null) {
            mediaTracker.addImage(this.backgroundImage, 0);
        }
        if (this.buttonImage != null) {
            mediaTracker.addImage(this.buttonImage, 1);
        }
        mediaTracker.checkAll(true);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException exception) {
            return;
        }
        if (this.buttonImage != null) {
            this.submitButton.repaint();
            if (!this.registered) {
                this.registeredButton.repaint();
            }
        }
        this.labelStringsState = 1;
        this.passwordTextField.requestFocus();
        this.repaint();
        this.loadingThread = null;
    }

    public void destroy() {
        if (this.loadingThread != null) {
            this.loadingThread.interrupt();
        }
    }

    public void actionPerformed(int actionIndex) {
        if (!this.registered && actionIndex == -1) {
            this.linkToRA();
        } else {
            this.checkSecretURL();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.registered && actionEvent.getSource() == this.registeredButton) {
            this.linkToRA();
        } else {
            this.checkSecretURL();
        }
    }

    private void linkToRA() {
        try {
            this.getAppletContext().showDocument(new URL("http://www.realapplets.com"), "_blank");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkSecretURL() {
        if (this.attemptsIndex < this.attemptsTotal) {
            String secretURLString = this.passwordTextField.getText();
            switch (this.convertPassToCase) {
                case 1: {
                    secretURLString = secretURLString.toLowerCase();
                    break;
                }
                case 2: {
                    secretURLString = secretURLString.toUpperCase();
                    break;
                }
            }
            secretURLString = secretURLString + this.extension;
            try {
                URL secretURL = new URL(this.getDocumentBase(), secretURLString);
                HttpURLConnection secretURLConnection = null;
                int responseCode = 200;
                try {
                    secretURLConnection = (HttpURLConnection)secretURL.openConnection();
                    secretURLConnection.setRequestMethod("HEAD");
                    responseCode = secretURLConnection.getResponseCode();
                }
                catch (ClassCastException classCastException) {
                    responseCode = -1;
                }
                if (responseCode < 0) {
                    InputStream secretInput;
                    block18: {
                        responseCode = 200;
                        secretInput = secretURL.openStream();
                        try {
                            int i = 0;
                            while (true) {
                                if (i >= 5) {
                                    break block18;
                                }
                                int inputChar = secretInput.read();
                                if (inputChar < 0) {
                                    responseCode = 404;
                                    Object var9_10 = null;
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            secretInput.close();
                            throw throwable;
                        }
                        secretInput.close();
                        return;
                    }
                    Object var9_11 = null;
                    secretInput.close();
                }
                if (responseCode < 200 || responseCode >= 300) {
                    throw new Exception();
                }
                this.labelStringsState = 2;
                this.getAppletContext().showDocument(secretURL, this.targetFrame);
                this.passwordTextField.setText("");
            }
            catch (Exception exception) {
                ++this.attemptsIndex;
                this.labelStringsState = 3;
                if (this.attemptsIndex >= this.attemptsTotal) {
                    this.getAppletContext().showDocument(this.wrongPassURL, this.targetFrame);
                }
                this.passwordTextField.setText("");
                this.passwordTextField.requestFocus();
            }
        } else {
            this.labelStringsState = 4;
        }
        this.repaint();
    }

    public void setErrorString(String errorString) {
        this.setErrorString(errorString, null);
    }

    public void setErrorString(String errorString, Exception exception) {
        this.errorString = errorString;
        if (exception != null) {
            System.out.println(errorString + "\n" + exception);
        } else {
            System.out.println(errorString);
        }
        this.removeAll();
        this.repaint();
    }

    public String getParameter(String parameterName) {
        String parameterValue = super.getParameter(parameterName);
        if (parameterValue != null) {
            return parameterValue;
        }
        return "";
    }

    private void confirmBuffer() {
        Dimension size = this.getSize();
        if (this.bufferSize == null || !this.bufferSize.equals(size)) {
            if (size.width < 30) {
                size.width = 30;
            }
            if (size.height < 70) {
                size.height = 70;
            }
            this.bufferImage = this.createImage(size.width, size.height);
            this.bufferGraphics = this.bufferImage.getGraphics();
            Font labelFont = null;
            labelFont = this.labelFontSize > 0 ? new Font(this.labelFontStyle, 0, this.labelFontSize) : new Font(this.labelFontStyle, 0, (size.height - 40) / 3 - 6);
            this.bufferGraphics.setFont(labelFont);
            this.labelFontMetrics = this.bufferGraphics.getFontMetrics();
            this.bufferSize = new Dimension(size);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.errorString != null) {
            Dimension size = this.getSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, size.width, size.height);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Arial", 0, 16));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.errorString, (size.width - fontMetrics.stringWidth(this.errorString)) / 2, (size.height + 16) / 2 - fontMetrics.getDescent());
        } else {
            this.confirmBuffer();
            if (this.backgroundImage != null) {
                int imageWidth = this.backgroundImage.getWidth(this);
                int imageHeight = this.backgroundImage.getHeight(this);
                if (imageWidth >= 0 && imageHeight >= 0) {
                    this.bufferGraphics.drawImage(this.backgroundImage, 0, 0, this.bufferSize.width, this.bufferSize.height, 0, 0, imageWidth, imageHeight, this);
                } else {
                    this.bufferGraphics.setColor(this.colors[0]);
                    this.bufferGraphics.fillRect(0, 0, this.bufferSize.width, this.bufferSize.height);
                }
            } else {
                this.bufferGraphics.setColor(this.colors[0]);
                this.bufferGraphics.fillRect(0, 0, this.bufferSize.width, this.bufferSize.height);
            }
            this.bufferGraphics.setColor(this.colors[1]);
            int labelX = 10;
            switch (this.labelFontAlignment) {
                case 0: {
                    labelX = 10;
                    break;
                }
                case 1: {
                    labelX = (this.bufferSize.width - this.labelFontMetrics.stringWidth(this.labelStrings[this.labelStringsState])) / 2;
                    break;
                }
                case 2: {
                    labelX = this.bufferSize.width - 10 - this.labelFontMetrics.stringWidth(this.labelStrings[this.labelStringsState]);
                }
            }
            int labelY = (this.labelFontSize == 0 ? (this.bufferSize.height - 19) / 3 : ((this.bufferSize.height + 20) / 3 + this.labelFontSize) / 2) - this.labelFontMetrics.getDescent();
            this.bufferGraphics.drawString(this.labelStrings[this.labelStringsState], labelX, labelY);
            graphics.drawImage(this.bufferImage, 0, 0, this);
        }
    }
}

